# let make search for cpp dependencies in ../../src

vpath %.cpp ../../src ../../src/splay ../../src/hip ../../src/frame ../../src/mpegAudioFrame
vpath %.c ../../src/hip


# tell make how to create the .d files
# => call gcc with -MM on the corresponding .cpp file

depends/%.cpp.d: %.cpp
	$(DEPGEN:__destfile__=$@)
	"../gcctemplate/tools/InsertTarget" "$@ $(subst depends/,output/,$(subst .d,.o,$@))" "$@"

depends/%.c.d: %.c
	$(DEPGEN:__destfile__=$@)
	"../gcctemplate/tools/InsertTarget" "$@ $(subst depends/,output/,$(subst .dc,.oc,$@))" "$@"


# tell make how to create .o files
# => compile the corresponding .cpp and .c files

output/%.cpp.o : %.cpp
	$(CC) -c $(CFLAGS) $(CPPFLAGS) $< -o $@

output/%.c.o : %.c
	$(CC) -c $(CFLAGS) $(CPPFLAGS) $< -o $@

